/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.auiml.databeans.sfp;

import com.ibm.hsc.auiml.databeans.sfp.SFPException;
import com.ibm.hsc.auiml.databeans.sfp.SFPUtil;
import com.ibm.hsc.auiml.databeans.sfp.data.CECStateInformation;
import com.ibm.hsc.auiml.databeans.sfp.data.SFPSettingsInformation;
import com.ibm.hsc.common.bundles.HSCResourceBundleUtil;
import com.ibm.hsc.common.util.Trace;
import com.ibm.hwmca.fw.tasklet.PanelBean;
import com.ibm.hwmca.fw.tasklet.PanelTaskletRequest;
import com.ibm.ui.framework.ActionDescriptor;
import com.ibm.ui.framework.Capabilities;
import com.ibm.ui.framework.ColumnDescriptor;
import com.ibm.ui.framework.IllegalUserDataException;
import com.ibm.ui.framework.ItemDescriptor;
import com.ibm.ui.framework.TaskActionEvent;
import com.ibm.ui.framework.UserTaskManager;
import com.ibm.ui.framework.ValueDescriptor;
import com.ibm.websm.mobject.MOClass;
import java.util.HashMap;

public class SFPSettingsBean
extends PanelBean {
    private ActionDescriptor[] m_adSurveillanceNotificationMenu;
    private ActionDescriptor[] m_adSurveillanceMenu;
    private ItemDescriptor[] m_idSurveillanceNotificationCECTable;
    private ColumnDescriptor[] m_cdSurveillanceNotificationCECTableStructure;
    private int[] m_iSurveillanceNotificationCECTableSelection;
    private String m_sSurveillanceNotificationSortByComboBox;
    private ValueDescriptor[] m_cdSurveillanceNotificationSortByComboBox;
    private ItemDescriptor[] m_idCallHomeCECTable;
    private ColumnDescriptor[] m_cdCallHomeCECTableStructure;
    private int[] m_iCallHomeCECTableSelection;
    private String m_sCallHomeSortByComboBox;
    private ValueDescriptor[] m_cdCallHomeSortByComboBox;
    private double m_dSurveillanceDisconnectedTimer;
    private double m_dSurveillanceConnectedTimer;
    private double m_dSurveillanceOutageIntervalTimer;
    private ItemDescriptor[] m_idSurveillanceCECTable;
    private ColumnDescriptor[] m_cdSurveillanceCECTableStructure;
    private int[] m_iSurveillanceCECTableSelection;
    private String m_sSurveillanceSortByComboBox;
    private ValueDescriptor[] m_cdSurveillanceSortByComboBox;
    private SFPSettingsInformation surveillanceSettings;
    private MOClass targetClass;
    private boolean writeAccess = false;
    private int machineCount = 0;
    public static final String CALL_HOME_CEC_TABLE_NAME = "SFPCallHome.CallHomeCECTable";
    public static final String SURVEILLANCE_CEC_TABLE_NAME = "SurveillanceCECTable";
    public static final String SURVEILLANCE_NOTIFICATION_CEC_TABLE_NAME = "SFPLanSurveillanceNotification.SurveillanceNotificationCECTable";
    public static final String SURVEILLANCE_COMBOBOX_NAME = "SFPLanSurveillance.SurveillanceSortByComboBox";
    public static final String SURVEILLANCE_NOTIFICATION_COMBOBOX_NAME = "SFPLanSurveillanceNotification.SurveillanceNotificationSortByComboBox";
    public static final String SURVEILLANCE_CONNECTED_NAME = "SFPLanSurveillance.SurveillanceConnectedTimer";
    public static final String SURVEILLANCE_DISCONNECTED_NAME = "SFPLanSurveillance.SurveillanceDisconnectedTimer";
    public static final String SURVEILLANCE_INTERVAL_NAME = "SFPLanSurveillance.SurveillanceOutageIntervalTimer";
    public static final String OK_BUTTON = "OK";
    public static final String SURVEILLANCE_ENABLE_BUTTON = "SurveillanceEnableButton";
    public static final String SURVEILLANCE_DISABLE_BUTTON = "SurveillanceDisableButton";
    public static final String SURVEILLANCE_TOGGLE = "SFPLanSurveillance.SurveillanceContextMenu.SurveillanceToggle";
    public static final String SURVEILLANCE_NOTIFICATION_TOGGLE = "SFPLanSurveillanceNotification.SurveillanceNotificationContextMenu.SurveillanceNotificationToggle";
    public static final String ENABLED_LABEL = HSCResourceBundleUtil.getMessage("SFPResourceBundle", "ENABLED_LBL", "Enabled");
    public static final String DISABLED_LABEL = HSCResourceBundleUtil.getMessage("SFPResourceBundle", "DISABLED_LBL", "Disabled");
    public static final String UNKNOWN_LABEL = HSCResourceBundleUtil.getMessage("SFPResourceBundle", "UNKNOWN_LBL", "Unknown");
    public static final int MACHINE_NAME_COLUMN = 0;
    public static final int STATE_COLUMN = 1;
    public static final int MACHINE_ID_COLUMN = 2;
    private static HashMap CALL_HOME_CHOICES = new HashMap(3);
    private static HashMap SURVEILLANCE_CHOICES = new HashMap(3);
    private static HashMap SURVEILLANCE_NOTIFICATION_CHOICES = new HashMap(3);
    private static HashMap ALL_CHOICES = new HashMap(3);
    private static final String TRACE_MASKD = "JSFPSETD";
    private static final String TRACE_MASKF = "JSFPSETF";
    private static final String TRACE_MASKT = "JSFPSETT";

    public SFPSettingsBean(SFPSettingsInformation sFPSettingsInformation) {
        if (2 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKF, "->SFPSettingsBean(settings)");
        }
        this.surveillanceSettings = sFPSettingsInformation;
        this.writeAccess = true;
        if (2 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKF, "<-SFPSettingsBean(settings)");
        }
    }

    public SFPSettingsBean(MOClass mOClass) {
        this.targetClass = mOClass;
        this.writeAccess = SFPUtil.determineWriteAuthorization(mOClass);
    }

    public ColumnDescriptor[] getSurveillanceNotificationCECTableRowStructure() {
        return this.m_cdSurveillanceNotificationCECTableStructure;
    }

    public int getSurveillanceNotificationCECTableRowStatus() {
        return 3;
    }

    public int getSurveillanceNotificationCECTableRowCount() {
        return 0;
    }

    public ItemDescriptor[] getSurveillanceNotificationCECTableRowAt(int n) {
        return this.m_idSurveillanceNotificationCECTable;
    }

    public void setSurveillanceNotificationCECTableRowAt(int n, ItemDescriptor[] itemDescriptorArray) throws IllegalUserDataException {
        this.m_idSurveillanceNotificationCECTable = itemDescriptorArray;
    }

    public int[] getSurveillanceNotificationCECTableSelection() {
        return this.m_iSurveillanceNotificationCECTableSelection;
    }

    public void setSurveillanceNotificationCECTableSelection(int[] nArray) throws IllegalUserDataException {
        this.m_iSurveillanceNotificationCECTableSelection = nArray;
    }

    public String getSurveillanceNotificationSortByComboBox() {
        return this.m_sSurveillanceNotificationSortByComboBox;
    }

    public void setSurveillanceNotificationSortByComboBox(String string) throws IllegalUserDataException {
        this.m_sSurveillanceNotificationSortByComboBox = string;
    }

    public ValueDescriptor[] getSurveillanceNotificationSortByComboBoxList() {
        return this.m_cdSurveillanceNotificationSortByComboBox;
    }

    public ColumnDescriptor[] getCallHomeCECTableRowStructure() {
        return this.m_cdCallHomeCECTableStructure;
    }

    public int getCallHomeCECTableRowStatus() {
        return 3;
    }

    public int getCallHomeCECTableRowCount() {
        return 0;
    }

    public ItemDescriptor[] getCallHomeCECTableRowAt(int n) {
        return this.m_idCallHomeCECTable;
    }

    public void setCallHomeCECTableRowAt(int n, ItemDescriptor[] itemDescriptorArray) throws IllegalUserDataException {
        this.m_idCallHomeCECTable = itemDescriptorArray;
    }

    public int[] getCallHomeCECTableSelection() {
        return this.m_iCallHomeCECTableSelection;
    }

    public void setCallHomeCECTableSelection(int[] nArray) throws IllegalUserDataException {
        this.m_iCallHomeCECTableSelection = nArray;
    }

    public String getCallHomeSortByComboBox() {
        return this.m_sCallHomeSortByComboBox;
    }

    public void setCallHomeSortByComboBox(String string) throws IllegalUserDataException {
        this.m_sCallHomeSortByComboBox = string;
    }

    public ValueDescriptor[] getCallHomeSortByComboBoxList() {
        return this.m_cdCallHomeSortByComboBox;
    }

    public double getSurveillanceDisconnectedTimer() {
        return this.m_dSurveillanceDisconnectedTimer;
    }

    public void setSurveillanceDisconnectedTimer(double d) throws IllegalUserDataException {
        this.m_dSurveillanceDisconnectedTimer = d;
    }

    public double getSurveillanceConnectedTimer() {
        return this.m_dSurveillanceConnectedTimer;
    }

    public void setSurveillanceConnectedTimer(double d) throws IllegalUserDataException {
        this.m_dSurveillanceConnectedTimer = d;
    }

    public double getSurveillanceOutageIntervalTimer() {
        return this.m_dSurveillanceOutageIntervalTimer;
    }

    public void setSurveillanceOutageIntervalTimer(double d) throws IllegalUserDataException {
        this.m_dSurveillanceOutageIntervalTimer = d;
    }

    public ColumnDescriptor[] getSurveillanceCECTableRowStructure() {
        return this.m_cdSurveillanceCECTableStructure;
    }

    public int getSurveillanceCECTableRowStatus() {
        return 3;
    }

    public int getSurveillanceCECTableRowCount() {
        return 0;
    }

    public ItemDescriptor[] getSurveillanceCECTableRowAt(int n) {
        return this.m_idSurveillanceCECTable;
    }

    public void setSurveillanceCECTableRowAt(int n, ItemDescriptor[] itemDescriptorArray) throws IllegalUserDataException {
        this.m_idSurveillanceCECTable = itemDescriptorArray;
    }

    public int[] getSurveillanceCECTableSelection() {
        return this.m_iSurveillanceCECTableSelection;
    }

    public void setSurveillanceCECTableSelection(int[] nArray) throws IllegalUserDataException {
        this.m_iSurveillanceCECTableSelection = nArray;
    }

    public String getSurveillanceSortByComboBox() {
        return this.m_sSurveillanceSortByComboBox;
    }

    public void setSurveillanceSortByComboBox(String string) throws IllegalUserDataException {
        this.m_sSurveillanceSortByComboBox = string;
    }

    public ValueDescriptor[] getSurveillanceSortByComboBoxList() {
        return this.m_cdSurveillanceSortByComboBox;
    }

    public ActionDescriptor[] getSurveillanceMenuList() {
        return this.m_adSurveillanceMenu;
    }

    public ActionDescriptor[] getSurveillanceNotificationMenuList() {
        return this.m_adSurveillanceNotificationMenu;
    }

    public Capabilities getCapabilities() {
        return null;
    }

    public void verifyChanges() throws IllegalUserDataException {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "->SFPSettingsBean.verifyChanges()");
        }
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<-SFPSettingsBean.verifyChanges()");
        }
    }

    public void save() {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "->SFPSettingsBean.save()");
        }
        try {
            SFPSettingsInformation sFPSettingsInformation = this.saveChoices();
        }
        catch (SFPException sFPException) {
            if (2 <= Trace.LEVEL) {
                Trace.trace(TRACE_MASKF, "SFPSettingsBean.saveChoices() caught SFPException: " + sFPException.toString());
            }
            try {
                SFPUtil.showSFPErrorWindowMessageModal(sFPException.getKey(), HSCResourceBundleUtil.getMessage("SFPResourceBundleMessages", sFPException.getKey(), "An error occurred when changing the state.  Can not display message " + sFPException.getKey()), HSCResourceBundleUtil.getMessage("SFPResourceBundle", "SFP_MESSAGE_ERROR_TITLE", "Service Focal Point Error"), this.getUTM());
            }
            catch (Throwable throwable) {
                SFPUtil.showSFPErrorWindowMessageModal("0000", "An error occurred when changing the state.  Can not display message " + sFPException.getKey(), HSCResourceBundleUtil.getMessage("SFPResourceBundle", "SFP_MESSAGE_ERROR_TITLE", "Service Focal Point Error"), this.getUTM());
            }
        }
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<-SFPSettingsBean.save()");
        }
    }

    public void prepare() {
        if (!this.hasWriteAccess()) {
            this.getUTM().setEnabled(OK_BUTTON, false);
        } else {
            this.getUTM().setEnabled(OK_BUTTON, true);
            this.getUTM().setEnabled(SURVEILLANCE_ENABLE_BUTTON, true);
            this.getUTM().setEnabled(SURVEILLANCE_DISABLE_BUTTON, true);
        }
        try {
            this.populateChoices();
        }
        catch (SFPException sFPException) {
            if (2 <= Trace.LEVEL) {
                Trace.trace(TRACE_MASKF, "SFPSettingsBean.populateChoices() caught SFPException: " + sFPException.toString());
            }
            try {
                SFPUtil.showSFPErrorWindowMessageModal(sFPException.getKey(), HSCResourceBundleUtil.getMessage("SFPResourceBundleMessages", sFPException.getKey(), "An error occurred when changing the state.  Can not display message " + sFPException.getKey()), HSCResourceBundleUtil.getMessage("SFPResourceBundle", "SFP_MESSAGE_ERROR_TITLE", "Service Focal Point Error"), this.getUTM());
            }
            catch (Throwable throwable) {
                SFPUtil.showSFPErrorWindowMessageModal("0000", "An error occurred when changing the state.  Can not display message " + sFPException.getKey(), HSCResourceBundleUtil.getMessage("SFPResourceBundle", "SFP_MESSAGE_ERROR_TITLE", "Service Focal Point Error"), this.getUTM());
            }
        }
    }

    private UserTaskManager getUTM() {
        return this.getUserTaskManager();
    }

    private SFPSettingsInformation saveChoices() throws SFPException {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "->SFPSettingsBean.saveChoices()");
        }
        SFPSettingsInformation sFPSettingsInformation = new SFPSettingsInformation();
        try {
            String string;
            Object object;
            CECStateInformation cECStateInformation;
            int n;
            this.getUTM().storeAllElements();
            sFPSettingsInformation.connected = (int)this.getSurveillanceConnectedTimer();
            sFPSettingsInformation.disconnected = (int)this.getSurveillanceDisconnectedTimer();
            sFPSettingsInformation.interval = (int)this.getSurveillanceOutageIntervalTimer();
            sFPSettingsInformation.stateInformation = new CECStateInformation[this.machineCount];
            if (2 <= Trace.LEVEL) {
                Trace.trace(TRACE_MASKF, "SFPSettingsBean.saveChoices() about to build CECStateInformation objects");
            }
            for (n = 0; n < sFPSettingsInformation.stateInformation.length; ++n) {
                sFPSettingsInformation.stateInformation[n] = cECStateInformation = new CECStateInformation();
                if (2 <= Trace.LEVEL) {
                    Trace.trace(TRACE_MASKF, "SFPSettingsBean.saveChoices() about to fetch row " + n);
                }
                object = this.getUTM().getRow(SURVEILLANCE_CEC_TABLE_NAME, n);
                String string2 = object[2].getTitle();
                int n2 = string2.indexOf("/");
                string = string2.substring(0, n2);
                String string3 = string2.substring(n2 + 1);
                cECStateInformation.machineModelType = string;
                cECStateInformation.machineSerial = string3;
                cECStateInformation.machineName = object[0].getTitle();
                cECStateInformation.callHomeState = object[1].getTitle();
            }
            if (2 <= Trace.LEVEL) {
                Trace.trace(TRACE_MASKF, "SFPSettingsBean.saveChoices() about to set surveillance states");
            }
            block3: for (n = 0; n < sFPSettingsInformation.stateInformation.length; ++n) {
                cECStateInformation = sFPSettingsInformation.stateInformation[n];
                object = cECStateInformation.getMachineId();
                for (int i = 0; i < this.machineCount; ++i) {
                    ItemDescriptor[] itemDescriptorArray = this.getUTM().getRow(SURVEILLANCE_CEC_TABLE_NAME, i);
                    string = itemDescriptorArray[2].getTitle();
                    if (!string.equals(object)) continue;
                    cECStateInformation.surveillanceState = itemDescriptorArray[1].getTitle();
                    continue block3;
                }
            }
        }
        catch (Exception exception) {
            if (2 <= Trace.LEVEL) {
                Trace.trace(TRACE_MASKT, "SFPSettingsBean.saveChoices() caught Exception");
                Trace.trace(TRACE_MASKT, "SFPSettingsBean.saveChoices() throwing SFPException");
            }
            throw new SFPException("0150", exception);
        }
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<-SFPSettingsBean.saveChoices()");
        }
        return sFPSettingsInformation;
    }

    public void load() {
    }

    public void populateChoices() throws SFPException {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "-> SFPSettingsBean.populateChoices()");
        }
        try {
            if (this.surveillanceSettings == null) {
                if (2 <= Trace.LEVEL) {
                    Trace.trace(TRACE_MASKF, "SFPSettingsBean.populateChoices() No Settings were provided to SFPSettingsBean");
                }
                return;
            }
            CECStateInformation[] cECStateInformationArray = this.surveillanceSettings.stateInformation;
            if (cECStateInformationArray == null) {
                if (2 <= Trace.LEVEL) {
                    Trace.trace(TRACE_MASKF, "SFPSettingsBean.populateChoices() No CECs were provided to SFPSettingsBean");
                }
            } else {
                this.machineCount = cECStateInformationArray.length;
                if (2 <= Trace.LEVEL) {
                    Trace.trace(TRACE_MASKF, "SFPSettingsBean.populateChoices() Number of entries in CEC table is " + this.machineCount);
                }
                for (int i = 0; i < this.machineCount; ++i) {
                    ItemDescriptor[] itemDescriptorArray = new ItemDescriptor[3];
                    itemDescriptorArray = new ItemDescriptor[]{new ItemDescriptor("SurveillanceCECTable." + i + "." + 0, cECStateInformationArray[i].machineName), new ItemDescriptor("SurveillanceCECTable." + i + "." + 1, cECStateInformationArray[i].surveillanceState), new ItemDescriptor("SurveillanceCECTable." + i + "." + 2, cECStateInformationArray[i].getMachineId())};
                    this.getUTM().addRow(SURVEILLANCE_CEC_TABLE_NAME, i, itemDescriptorArray);
                }
            }
            this.setSurveillanceConnectedTimer(this.surveillanceSettings.connected);
            this.setSurveillanceDisconnectedTimer(this.surveillanceSettings.disconnected);
            this.setSurveillanceOutageIntervalTimer(this.surveillanceSettings.interval);
            this.getUTM().refreshAllElements();
        }
        catch (Exception exception) {
            if (1 <= Trace.LEVEL) {
                Trace.trace(TRACE_MASKT, "<-SFPSettingsBean.populateChoices() caught Exception: " + exception);
            }
            throw new SFPException("0149", exception);
        }
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<- SFPSettingsBean.populateChoices()");
        }
    }

    public synchronized boolean hasWriteAccess() {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "-> SFPSettingsBean.hasWriteAccess(), writeAccess is " + this.writeAccess);
            Trace.trace(TRACE_MASKT, "<- SFPSettingsBean.hasWriteAccess()");
        }
        return this.writeAccess;
    }

    public void panelAction(TaskActionEvent taskActionEvent) {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "panelAction( " + taskActionEvent + " )");
            Trace.trace(TRACE_MASKT, "panelAction( " + taskActionEvent.getElementName() + " )");
        }
        String string = "";
        UserTaskManager userTaskManager = this.getUTM();
        String string2 = taskActionEvent.getElementName();
        String string3 = "";
        if (string2.equals("Cancel")) {
            if (1 <= Trace.LEVEL) {
                Trace.trace(TRACE_MASKF, "Cancel pushed");
            }
            this.dispose();
        } else {
            if (1 <= Trace.LEVEL) {
                Trace.trace(TRACE_MASKF, "panelAction( " + taskActionEvent + " )");
            }
            if (string2.equals(OK_BUTTON)) {
                if (1 <= Trace.LEVEL) {
                    Trace.trace(TRACE_MASKF, "OK pushed");
                }
                try {
                    this.surveillanceSettings = this.saveChoices();
                }
                catch (SFPException sFPException) {
                    if (2 <= Trace.LEVEL) {
                        Trace.trace(TRACE_MASKF, "SFPSettingsBean.saveChoices() caught SFPException: " + sFPException.toString());
                    }
                    try {
                        SFPUtil.showSFPErrorWindowMessageModal(sFPException.getKey(), HSCResourceBundleUtil.getMessage("SFPResourceBundleMessages", sFPException.getKey(), "An error occurred when changing the state.  Can not display message " + sFPException.getKey()), HSCResourceBundleUtil.getMessage("SFPResourceBundle", "SFP_MESSAGE_ERROR_TITLE", "Service Focal Point Error"), this.getUTM());
                    }
                    catch (Throwable throwable) {
                        SFPUtil.showSFPErrorWindowMessageModal("0000", "An error occurred when changing the state.  Can not display message " + sFPException.getKey(), HSCResourceBundleUtil.getMessage("SFPResourceBundle", "SFP_MESSAGE_ERROR_TITLE", "Service Focal Point Error"), this.getUTM());
                    }
                    return;
                }
                PanelTaskletRequest panelTaskletRequest = new PanelTaskletRequest();
                panelTaskletRequest.setData("event", (Object)taskActionEvent);
                panelTaskletRequest.setData("action", (Object)"ok");
                panelTaskletRequest.setData("settings", (Object)this.surveillanceSettings);
                this.postTaskletRequest(panelTaskletRequest);
            } else if (string2.equals(SURVEILLANCE_ENABLE_BUTTON) || string2.equals(SURVEILLANCE_DISABLE_BUTTON)) {
                if (string2.equals(SURVEILLANCE_ENABLE_BUTTON)) {
                    string3 = ENABLED_LABEL;
                    if (1 <= Trace.LEVEL) {
                        Trace.trace(TRACE_MASKF, "Enable pushed");
                    }
                } else {
                    string3 = DISABLED_LABEL;
                    if (1 <= Trace.LEVEL) {
                        Trace.trace(TRACE_MASKF, "Disable pushed");
                    }
                }
                int[] nArray = this.getUTM().getSelectedRows(SURVEILLANCE_CEC_TABLE_NAME);
                int n = nArray.length;
                if (1 <= Trace.LEVEL) {
                    Trace.trace(TRACE_MASKF, "Number of selected rows is " + n);
                }
                if (n == 0) {
                    PanelTaskletRequest panelTaskletRequest = new PanelTaskletRequest();
                    panelTaskletRequest.setData("event", (Object)taskActionEvent);
                    panelTaskletRequest.setData("action", (Object)"errorMessage");
                    panelTaskletRequest.setData("msgkey", (Object)"0096");
                    this.postTaskletRequest(panelTaskletRequest);
                } else {
                    for (int i = 0; i < n; ++i) {
                        ItemDescriptor[] itemDescriptorArray;
                        if (2 <= Trace.LEVEL) {
                            Trace.trace(TRACE_MASKF, "Parsing selected index: " + i);
                        }
                        if ((itemDescriptorArray = this.getUTM().getRow(SURVEILLANCE_CEC_TABLE_NAME, nArray[i]))[1].getTitle().equals(UNKNOWN_LABEL)) {
                            PanelTaskletRequest panelTaskletRequest = new PanelTaskletRequest();
                            panelTaskletRequest.setData("event", (Object)taskActionEvent);
                            panelTaskletRequest.setData("action", (Object)"errorMessage");
                            panelTaskletRequest.setData("msgkey", (Object)"0060");
                            this.postTaskletRequest(panelTaskletRequest);
                            continue;
                        }
                        itemDescriptorArray[1].setTitle(string3);
                        this.getUTM().setRow(SURVEILLANCE_CEC_TABLE_NAME, nArray[i], itemDescriptorArray);
                    }
                }
                this.getUTM().refreshAllElements();
            }
            if (1 <= Trace.LEVEL) {
                Trace.trace(TRACE_MASKT, "<- SFPSettingsBean().panelAction");
            }
        }
    }

    static {
        if (2 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKF, "->SFPSettingsBean(static)");
        }
        Integer n = new Integer(0);
        Integer n2 = new Integer(1);
        Integer n3 = new Integer(2);
        String string = "com.ibm.hsc.auiml.databeans.sfp.SFPSurveillance";
        if (2 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKF, "<-SFPSettingsBean(static)");
        }
    }
}

